"""
Analyse an inventory
====================

.. sectionauthor:: Julian Heinze (Helmholtz Centre for Environmental Research GmbH - UFZ)

This example shows the different types of statistics that can be applied to an existing inventory for analysis.
"""

# %%
# Necessary imports
from spatiocoexistence import Inventory
from spatiocoexistence.data import inventory_file

# %%
# 1. Initialize the inventory
inv = Inventory.from_data(inventory_file)
# %%
# 2. Access the data from the inventory.
all_data = inv.data
x = inv.x
dbh = inv.dbh
species = inv.species
crowding_conspecifics_BA = inv.CI_CS
crowding_conspecifics = inv.CI_C

# %%
# 3. Get the species abundance of that inventory. The index refers to that species.
inv.species_abundance()[10]

# %%
# 4. Get the amount of reproductive individuals per species that are alive.
# The reproduction is defined by a tree being larger than the reproductive size.
# In this example we set it to = 2dm, and assume it holds for all tree species.
inv.count_reproductives(2)

# %% 5.
# Get the summary statistics of the plot. More information how to calculate them can be found in ...
# ToDo
inv.get_BA_and_k()

# %% 6.
# The inventory can be mapped, and a graphic displaying all the statistics is also available.
inv.plot_map(scale=5, filter=2)
inv.plot(scale=5, filter=3)
